/*
 *  Gold.h
 *  Pirates!
 *
 *  Created by Alan Dorin on 3/12/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */
 
#ifndef _GOLD_H_
#define _GOLD_H_

#include "SimpleVector.h"

class Gold
{
	private:
		long	rewardAmount;		// gold reward offered *if* one is available
		long	index;				// index location in the goldArray of a Sea
		long	position[3];
	
	public:
		Gold();
		Gold(const Gold& src);
		~Gold();
		
		void setPosition(const long x, const long y, const long z);
		long getPositionX(void);
		long getPositionY(void);
		long getPositionZ(void);
		
		void setRewardAmount(long newReward);	
		long collectReward(void);
		
		long getIndex(void);
		void setIndex(long newIndex);
		
		void display(const SimpleVector& cellPosition, const SimpleVector& cellDimensions);
		
		Gold& operator= (const Gold& rhs);
};

#endif

